import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class LookAndFeelTest extends JFrame implements ActionListener {
	JButton bMetal = new JButton("Metal");
	JButton bWin = new JButton("Windows");
	JButton bMotif = new JButton("Motif");
	LookAndFeelTest() {
		getContentPane().setLayout(new FlowLayout());

		bMetal.addActionListener(this);
		bWin.addActionListener(this);
		bMotif.addActionListener(this);
		getContentPane().add(bMetal);
		getContentPane().add(bWin);
		getContentPane().add(bMotif);

		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("LookAndFeelTest");
		setSize(120, 160);
		setVisible(true);
	}
	public void actionPerformed(ActionEvent e) {
		String lookAndFeel = "";
		if (e.getSource() == bMetal) {
			lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
		} else if (e.getSource() == bWin) {
			lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
		} else if (e.getSource() == bMotif) {
			lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
		}
		try {
			UIManager.setLookAndFeel(lookAndFeel);
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	public static void main(String [] args) {
		new LookAndFeelTest();
	}
}
