import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class JScrollBarTest extends JFrame implements AdjustmentListener {
	JScrollBarTest() {
		getContentPane().setLayout(new FlowLayout());

		JScrollBar sb = new JScrollBar(JScrollBar.HORIZONTAL, 30, 5, 0, 105);
		sb.setPreferredSize(new Dimension(150, 17));
		sb.addAdjustmentListener(this);
		getContentPane().add(sb);

		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("JScrollBarTest");
		setSize(200, 120);
		setVisible(true);
	}
	public void adjustmentValueChanged(AdjustmentEvent e) {
		JScrollBar sb = (JScrollBar)e.getSource();
		System.out.println(sb.getValue());
	}
	public static void main(String[] args) {
		new JScrollBarTest();
	}
}
