import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;
import javax.swing.*;
import javax.swing.filechooser.*;

class TextEditor extends JFrame implements ActionListener {

	// vCx[gϐ
	private JToolBar toolBar;
	private JLabel statusBar;
	private JTextArea textArea;
	private JFileChooser fileChooser = new JFileChooser();

	//////////////////////////////////////////////////////////
	// 
	//////////////////////////////////////////////////////////

	// RXgN^
	TextEditor() {

		// Look&FeelWindows[hɂ
		OnLookAndFeel("Windows");

		// ^Cgo[ݒ肷
		setTitle("VK");

		// j[o[쐬
		InitMenuBar();

		// c[o[쐬
		InitToolBar();

		// Xe[^Xo[쐬
		InitStatusBar();

		// eLXgGA쐬
		InitTextArea(400, 500);

		// EBhEƂɃAvP[VI
		setDefaultCloseOperation(this.EXIT_ON_CLOSE);

		// EBhEK؂ȑ傫ɂ
		pack();

		// eLXgGAɃtH[JX𓖂Ă
		textArea.grabFocus();

		// EBhE
		setVisible(true);
	}

	// j[o[쐬
	void InitMenuBar() {

		// j[o[
		JMenuBar menuBar = new JMenuBar();
		getRootPane().setJMenuBar(menuBar);

		// [t@C]
		JMenu menuFile = new JMenu("t@C(F)");
		menuFile.setMnemonic('F');
		menuBar.add(menuFile);

		// [t@C]-[VK쐬]
		JMenuItem menuNew = new JMenuItem("VK쐬(N)");
		menuNew.setMnemonic('N');
		menuNew.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, Event.CTRL_MASK));
		menuNew.setActionCommand("New");
		menuNew.addActionListener(this);
		menuFile.add(menuNew);

		// [t@C]-[J]
		JMenuItem menuOpen = new JMenuItem("J(O)...");
		menuOpen.setMnemonic('O');
		menuOpen.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK));
		menuOpen.setActionCommand("Open");
		menuOpen.addActionListener(this);
		menuFile.add(menuOpen);

		// [t@C]-[㏑ۑ]
		JMenuItem menuSave = new JMenuItem("㏑ۑ(S)");
		menuSave.setMnemonic('S');
		menuSave.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK));
		menuSave.setActionCommand("Save");
		menuSave.addActionListener(this);
		menuFile.add(menuSave);

		// [t@C]-[Oĕۑ]
		JMenuItem menuSaveAs = new JMenuItem("Otĕۑ(A)...");
		menuSaveAs.setMnemonic('A');
		menuSaveAs.setActionCommand("SaveAs");
		menuSaveAs.addActionListener(this);
		menuFile.add(menuSaveAs);

		// [t@C]-[]
		JMenuItem menuPrint = new JMenuItem("(P)...");
		menuPrint.setMnemonic('P');
		menuPrint.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, Event.CTRL_MASK));
		menuPrint.setActionCommand("Print");
		menuPrint.addActionListener(this);
		menuFile.add(menuPrint);

		// [t@C]-[I]
		JMenuItem menuExit = new JMenuItem("I(X)");
		menuExit.setMnemonic('X');
		menuExit.setActionCommand("Exit");
		menuExit.addActionListener(this);
		menuFile.add(menuExit);

		// [ҏW]
		JMenu menuEdit = new JMenu("ҏW(E)");
		menuEdit.setMnemonic('E');
		menuBar.add(menuEdit);

		// [ҏW]-[؂]
		JMenuItem menuCut = new JMenuItem("؂(T)");
		menuCut.setMnemonic('T');
		menuCut.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, Event.CTRL_MASK));
		menuCut.setActionCommand("Cut");
		menuCut.addActionListener(this);
		menuEdit.add(menuCut);

		// [ҏW]-[Rs[]
		JMenuItem menuCopy = new JMenuItem("Rs[(C)");
		menuCopy.setMnemonic('C');
		menuCopy.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, Event.CTRL_MASK));
		menuCopy.setActionCommand("Copy");
		menuCopy.addActionListener(this);
		menuEdit.add(menuCopy);

		// [ҏW]-[\t]
		JMenuItem menuPaste = new JMenuItem("\t(P)");
		menuPaste.setMnemonic('P');
		menuPaste.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, Event.CTRL_MASK));
		menuPaste.setActionCommand("Paste");
		menuPaste.addActionListener(this);
		menuEdit.add(menuPaste);

		// [\]
		JMenu menuView = new JMenu("\(V)");
		menuView.setMnemonic('V');
		menuBar.add(menuView);

		// [\]-[c[o[]
		JCheckBoxMenuItem menuToolBar = new JCheckBoxMenuItem("c[o[(T)", true);
		menuToolBar.setMnemonic('T');
		menuToolBar.setActionCommand("ToolBar");
		menuToolBar.addActionListener(this);
		menuView.add(menuToolBar);

		// [\]-[Xe[^Xo[]
		JCheckBoxMenuItem menuStatusBar = new JCheckBoxMenuItem("Xe[^Xo[(S)", true);
		menuStatusBar.setMnemonic('S');
		menuStatusBar.setActionCommand("StatusBar");
		menuStatusBar.addActionListener(this);
		menuView.add(menuStatusBar);

		// [\]-[h]
		JMenu menuLookFeel = new JMenu("h(L)");
		menuLookFeel.setMnemonic('L');
		menuView.add(menuLookFeel);

		// [\]-[h]-[Metal]
		JMenuItem menuMetal = new JMenuItem("Metal(M)");
		menuMetal.setMnemonic('M');
		menuMetal.setActionCommand("Metal");
		menuMetal.addActionListener(this);
		menuLookFeel.add(menuMetal);

		// [\]-[h]-[Windows]
		JMenuItem menuWindows = new JMenuItem("Windows(W)");
		menuWindows.setMnemonic('W');
		menuWindows.setActionCommand("Windows");
		menuWindows.addActionListener(this);
		menuLookFeel.add(menuWindows);

		// [\]-[h]-[Motif]
		JMenuItem menuMotif = new JMenuItem("Motif(T)");
		menuMotif.setMnemonic('T');
		menuMotif.setActionCommand("Motif");
		menuMotif.addActionListener(this);
		menuLookFeel.add(menuMotif);

		// [wv]
		JMenu menuHelp = new JMenu("wv(H)");
		menuHelp.setMnemonic('H');
		menuBar.add(menuHelp);

		// [wv]-[o[W]
		JMenuItem menuAboud = new JMenuItem("o[W(A)...");
		menuAboud.setMnemonic('A');
		menuAboud.setActionCommand("About");
		menuAboud.addActionListener(this);
		menuHelp.add(menuAboud);
	}

	// c[o[쐬
	void InitToolBar() {
		toolBar = new JToolBar();
		toolBar.setFloatable(false);
//		toolBar.add(new JButton(new ImageIcon("new.gif")));

		JButton btnNew = new JButton("V");
		JButton btnOpen = new JButton("J");
		JButton btnSave = new JButton("");
		JButton btnAbout = new JButton("H");

		btnNew.setActionCommand("New");
		btnOpen.setActionCommand("Open");
		btnSave.setActionCommand("Save");
		btnAbout.setActionCommand("About");

		btnNew.addActionListener(this);
		btnOpen.addActionListener(this);
		btnSave.addActionListener(this);
		btnAbout.addActionListener(this);

		toolBar.add(btnNew);
		toolBar.add(btnOpen);
		toolBar.add(btnSave);
		toolBar.addSeparator();
		toolBar.add(btnAbout);

		getContentPane().add(toolBar, BorderLayout.NORTH);
	}

	// Xe[^Xo[쐬
	void InitStatusBar() {
		statusBar = new JLabel("@");
		getContentPane().add(statusBar, BorderLayout.SOUTH);
	}

	// eLXgGA쐬
	void InitTextArea(int width, int height) {
		textArea = new JTextArea();
		textArea.setWrapStyleWord(true);
 		textArea.setLineWrap(true);
		JScrollPane scroll = new JScrollPane(textArea);
		scroll.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		scroll.setPreferredSize(new Dimension(width, height));
		getContentPane().add(scroll, BorderLayout.CENTER);
	}

	//////////////////////////////////////////////////////////
	// Cxg
	//////////////////////////////////////////////////////////

	// Cxg
	public void actionPerformed(ActionEvent ae) {
		String cmd = ae.getActionCommand();
		if (cmd.equals("New")) {
			OnNew();
		} else if (cmd.equals("Open")) {
			OnOpen();
		} else if (cmd.equals("Save")) {
			OnSave();
		} else if (cmd.equals("SaveAs")) {
			OnSaveAs();
		} else if (cmd.equals("Print")) {
			// 
		} else if (cmd.equals("Exit")) {
			OnExit();
		} else if (cmd.equals("Cut")) {
			OnCut();
		} else if (cmd.equals("Copy")) {
			OnCopy();
		} else if (cmd.equals("Paste")) {
			OnPaste();
		} else if (cmd.equals("ToolBar")) {
			OnToolBar(((JCheckBoxMenuItem)ae.getSource()).getState());
		} else if (cmd.equals("StatusBar")) {
			OnStatusBar(((JCheckBoxMenuItem)ae.getSource()).getState());
		} else if (cmd.equals("Metal")) {
			OnLookAndFeel(cmd);
		} else if (cmd.equals("Windows")) {
			OnLookAndFeel(cmd);
		} else if (cmd.equals("Motif")) {
			OnLookAndFeel(cmd);
		} else if (cmd.equals("About")) {
			OnAbout();
		}
	}

	// [t@C]-[VK쐬]
	void OnNew() {
		fileChooser.setSelectedFile(null);
		setTitle("VK");
		textArea.setText("");
	}

	// [t@C]-[J]
	void OnOpen() {
		int returnVal = fileChooser.showOpenDialog(this);
		try {
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fileChooser.getSelectedFile();
				FileReader fr = new FileReader(file);
				textArea.read(fr, null);
				setTitle(file.getAbsolutePath());
				fr.close();
			}
		} catch(Exception ex) {}
	}

	// [t@C]-[㏑ۑ]
	void OnSave() {
		if (fileChooser.getSelectedFile() == null) {
			OnSaveAs();
		} else {
			try {
				FileWriter fw = new FileWriter(fileChooser.getSelectedFile());
				fw.write(textArea.getText());
				fw.close();
			} catch(Exception ex) {
				ex.printStackTrace();
			}
		}
	}

	// [t@C]-[Otĕۑ]
	void OnSaveAs() {
		int returnVal = fileChooser.showSaveDialog(this);
		try {
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				FileWriter fw = new FileWriter(fileChooser.getSelectedFile());
				fw.write(textArea.getText());
				fw.close();
			}
		} catch(Exception ex) {
			ex.printStackTrace();
		}
	}

	// [t@C]-[I]
	void OnExit() {
		System.exit(0);
	}

	// [ҏW]-[؂]
	void OnCut() {
		OnCopy();
		textArea.replaceRange(null, textArea.getSelectionStart(), textArea.getSelectionEnd());
	}

	// [ҏW]-[Rs[]
	void OnCopy() {
		Clipboard cb = getToolkit().getSystemClipboard();
		StringSelection strSel = new StringSelection(textArea.getSelectedText());
		cb.setContents(strSel, strSel);
	}

	// [ҏW]-[\t]
	void OnPaste() {
		Clipboard cb = getToolkit().getSystemClipboard();
		Transferable data = cb.getContents(this);
		if ((data != null) && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
			try {
				String str = (String)data.getTransferData(DataFlavor.stringFlavor);
				textArea.replaceRange(str, textArea.getSelectionStart(), textArea.getSelectionEnd());
			} catch (Exception e) { }
		}
	}

	// [\]-[c[o[]
	void OnToolBar(boolean b) {
		toolBar.setVisible(b);
	}

	// [\]-[Xe[^Xo[]
	void OnStatusBar(boolean b) {
		statusBar.setVisible(b);
	}

	// [\]-[bNtB[]
	void OnLookAndFeel(String type) {
		String lookAndFeel = "";
		if (type.equals("Metal")) {
			lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
		} else if (type.equals("Windows")) {
			lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
		} else if (type.equals("Motif")) {
			lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
		}
		try {
			UIManager.setLookAndFeel(lookAndFeel);
			SwingUtilities.updateComponentTreeUI(this);
		} catch (Exception ex) { }
	}

	// [wv]-[o[W]
	void OnAbout() {
		JOptionPane.showMessageDialog(this, "TextEditor Ver0.1", "TextEditor", JOptionPane.INFORMATION_MESSAGE);
	}

	//////////////////////////////////////////////////////////
	// C[`
	//////////////////////////////////////////////////////////

	// C[`
	public static void main(String[] args) {
		new TextEditor();
	}
}
